/*
 * Decompiled with CFR 0.152.
 */
package jcmdline;

import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import jcmdline.AbstractParameter;
import jcmdline.CmdLineException;
import jcmdline.Strings;

public class DateParam
extends AbstractParameter {
    private static final String sDateFmt = Strings.get("DateParam.dateFormat");
    private static final String sTimeFmt = "HH:mm:ss:SSS";
    private static final SimpleDateFormat dateFmt = new SimpleDateFormat(sDateFmt);
    private static final SimpleDateFormat dateFmtWTime = new SimpleDateFormat(sDateFmt + " " + "HH:mm:ss:SSS");
    private static final DecimalFormat hmsFmt = new DecimalFormat("00");
    private static final DecimalFormat msFmt = new DecimalFormat("000");
    private Date date = null;
    private int defaultHours = 0;
    private int defaultMinutes = 0;
    private int defaultSeconds = 0;
    private int defaultMilliSeconds = 0;

    public DateParam(String tag, String desc) {
        this(tag, desc, true, false, false);
    }

    public DateParam(String tag, String desc, boolean optional) {
        this(tag, desc, optional, false, false);
    }

    public DateParam(String tag, String desc, boolean optional, boolean multiValued) {
        this(tag, desc, optional, multiValued, false);
    }

    public DateParam(String tag, String desc, boolean optional, boolean multiValued, boolean hidden) {
        this.setTag(tag);
        this.setDesc(desc);
        this.setOptional(optional);
        this.setMultiValued(multiValued);
        this.setHidden(hidden);
        this.setOptionLabel(sDateFmt);
    }

    public DateParam(String tag, String desc, Date[] acceptableValues) {
        this(tag, desc, acceptableValues, true, false, false);
    }

    public DateParam(String tag, String desc, Date[] acceptableValues, boolean optional) {
        this(tag, desc, acceptableValues, optional, false, false);
    }

    public DateParam(String tag, String desc, Date[] acceptableValues, boolean optional, boolean multiValued) {
        this(tag, desc, acceptableValues, optional, multiValued, false);
    }

    public DateParam(String tag, String desc, Date[] acceptableValues, boolean optional, boolean multiValued, boolean hidden) {
        this.setTag(tag);
        this.setAcceptableDates(acceptableValues);
        this.setDesc(desc);
        this.setOptional(optional);
        this.setMultiValued(multiValued);
        this.setHidden(hidden);
        this.setOptionLabel(sDateFmt);
    }

    public void validateValue(String val) throws CmdLineException {
        super.validateValue(val);
        try {
            this.stringToDate(val);
        }
        catch (ParseException e) {
            throw new CmdLineException(Strings.get("DateParam.invalidDate", new Object[]{this.getTag(), sDateFmt}));
        }
    }

    public Date getDate() {
        String sVal = this.getValue();
        Date date = null;
        if (sVal != null) {
            try {
                date = this.stringToDate(sVal);
            }
            catch (ParseException e) {
                throw new RuntimeException(e);
            }
        }
        return date;
    }

    public Date[] getDates() {
        Collection sVals = this.getValues();
        Date[] dates = new Date[sVals.size()];
        Object date = null;
        int i = 0;
        Iterator itr = sVals.iterator();
        while (itr.hasNext()) {
            try {
                dates[i] = this.stringToDate((String)itr.next());
                ++i;
            }
            catch (ParseException e) {
                throw new RuntimeException(e);
            }
        }
        return dates;
    }

    public static String getParseFormat() {
        return dateFmt.toLocalizedPattern();
    }

    public void setAcceptableDates(Date[] dates) {
        String[] sDates = new String[dates.length];
        for (int i = 0; i < dates.length; ++i) {
            sDates[i] = dateFmt.format(dates[i]);
        }
        super.setAcceptableValues(sDates);
    }

    public Date[] getAcceptableDates() {
        String[] sVals = this.getAcceptableValues();
        if (sVals == null) {
            return null;
        }
        Date[] dates = new Date[sVals.length];
        for (int i = 0; i < sVals.length; ++i) {
            try {
                dates[i] = this.stringToDate(sVals[i]);
                continue;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return dates;
    }

    public void setAcceptableDates(Collection vals) {
        String[] sVals = new String[vals.size()];
        int i = 0;
        Iterator itr = vals.iterator();
        while (itr.hasNext()) {
            this.date = (Date)itr.next();
            sVals[i] = dateFmt.format(this.date);
            ++i;
        }
        super.setAcceptableValues(sVals);
    }

    public void setAcceptableValues(Collection vals) {
        throw new UnsupportedOperationException();
    }

    public void setAcceptableValues(String[] vals) {
        throw new UnsupportedOperationException();
    }

    public void setDefaultTime(int h, int m, int s, int ms) {
        if (h < 0 || h > 23) {
            throw new IllegalArgumentException(Strings.get("DateParam.invalidHours", new Object[]{new Integer(h)}));
        }
        if (m < 0 || m > 59) {
            throw new IllegalArgumentException(Strings.get("DateParam.invalidMinutes", new Object[]{new Integer(m)}));
        }
        if (s < 0 || s > 59) {
            throw new IllegalArgumentException(Strings.get("DateParam.invalidSeconds", new Object[]{new Integer(s)}));
        }
        if (ms < 0 || ms > 999) {
            throw new IllegalArgumentException(Strings.get("DateParam.invalidMilliSeconds", new Object[]{new Integer(ms)}));
        }
        this.defaultHours = h;
        this.defaultMinutes = m;
        this.defaultSeconds = s;
        this.defaultMilliSeconds = ms;
    }

    public int[] getDefaultTime() {
        return new int[]{this.defaultHours, this.defaultMinutes, this.defaultSeconds, this.defaultMilliSeconds};
    }

    private Date stringToDate(String val) throws ParseException {
        String sTime = hmsFmt.format(this.defaultHours) + ":" + hmsFmt.format(this.defaultMinutes) + ":" + hmsFmt.format(this.defaultSeconds) + ":" + msFmt.format(this.defaultMilliSeconds);
        return dateFmtWTime.parse(val + " " + sTime);
    }
}

