/*
 * Decompiled with CFR 0.152.
 */
package com.topaz.sigplus.util;

import java.io.Serializable;

public class TabletParameters
implements Serializable {
    int tabletXStart;
    int tabletXStop;
    int tabletYStart;
    int tabletYStop;
    int tabletFilterPoints;
    int tabletTimingAdvance;
    int tabletBaudRate;
    int tabletResolution;
    int tabletRotationMode;
    String tabletComPort = "COM1";
    boolean tabletComTest = false;
    int tabletFormat;
    String tabletModel;
    boolean tabletClippingMode = false;
    int tabletLCDCaptureMode;
    int tabletLCDType;
    int tabletLCDXSize;
    int tabletLCDYSize;
    int tabletLCDXStart;
    int tabletLCDXStop;
    int tabletLCDYStart;
    int tabletLCDYStop;
    int tabletLogicalXSize;
    int tabletLogicalYSize;
    int tabletMaxPointDelta = Short.MAX_VALUE;
    int tabletLCDCompressMode;
    int tabletLCDFastCompressionFactor;
    int tabletLCDSlowCompressionFactor;

    public TabletParameters() {
        this.setTabletModel("SignatureGem1X5");
    }

    public int getTabletLogicalXSize() {
        return this.tabletLogicalXSize;
    }

    public int getTabletLogicalYSize() {
        return this.tabletLogicalYSize;
    }

    public int getTabletXStart() {
        return this.tabletXStart;
    }

    public void setTabletXStart(int newValue) {
        this.calcLogicalSizes();
        this.tabletXStart = newValue;
    }

    public int getTabletXStop() {
        return this.tabletXStop;
    }

    public void setTabletXStop(int newValue) {
        this.calcLogicalSizes();
        this.tabletXStop = newValue;
    }

    public int getTabletYStart() {
        return this.tabletYStart;
    }

    public void setTabletYStart(int newValue) {
        this.calcLogicalSizes();
        this.tabletYStart = newValue;
    }

    public int getTabletYStop() {
        return this.tabletYStop;
    }

    public void setTabletYStop(int newValue) {
        this.calcLogicalSizes();
        this.tabletYStop = newValue;
    }

    public int getTabletFilterPoints() {
        return this.tabletFilterPoints;
    }

    public void setTabletFilterPoints(int newValue) {
        this.tabletFilterPoints = newValue;
    }

    public int getTabletTimingAdvance() {
        return this.tabletTimingAdvance;
    }

    public void setTabletTimingAdvance(int newValue) {
        this.tabletTimingAdvance = newValue;
    }

    public int getTabletBaudRate() {
        return this.tabletBaudRate;
    }

    public void setTabletBaudRate(int newValue) {
        this.tabletBaudRate = newValue;
    }

    public int getTabletRotationMode() {
        return this.tabletRotationMode;
    }

    public void setTabletResolution(int newValue) {
        this.tabletResolution = newValue;
    }

    public int getTabletResolution() {
        return this.tabletResolution;
    }

    public void setTabletRotationMode(int newValue) {
        this.tabletRotationMode = newValue;
    }

    public boolean getTabletComTest() {
        return this.tabletComTest;
    }

    public void setTabletComTest(boolean newValue) {
        this.tabletComTest = newValue;
    }

    public String getTabletComPort() {
        return this.tabletComPort;
    }

    public void setTabletComPort(String newValue) {
        this.tabletComPort = newValue;
    }

    public int getTabletFormat() {
        return this.tabletFormat;
    }

    public void setTabletFormat(int newValue) {
        this.tabletFormat = newValue;
    }

    public String getTabletModel() {
        return this.tabletModel;
    }

    public void setTabletModel(String model) {
        this.tabletModel = model;
        if (!model.equals("Custom")) {
            this.setTabletLCDParameters(0, 240, 128, 200, 2000, 250, 1300, 0, 0, 0);
        }
        if (model.equals("SignatureGem1X5")) {
            this.setTabletParameters(400, 2400, 350, 950, 4, 4, 19200, 410, 0, 0);
            return;
        }
        if (model.equals("SignatureGemLCD")) {
            this.setTabletParameters(400, 2400, 350, 1250, 4, 4, 19200, 410, 0, 1);
            return;
        }
        if (model.equals("SignatureGem4X5")) {
            this.setTabletParameters(500, 2650, 700, 2100, 4, 4, 19200, 410, 0, 0);
            return;
        }
        if (model.equals("ClipGem")) {
            this.setTabletParameters(485, 2800, 170, 3200, 2, 2, 9600, 275, 0, 0);
            return;
        }
        if (model.equals("ClipGem19200")) {
            this.setTabletParameters(485, 2800, 170, 3200, 4, 4, 19200, 275, 0, 0);
            return;
        }
        if (model.equals("ClipGemLGL")) {
            this.setTabletParameters(400, 2400, 150, 3450, 4, 4, 19200, 240, 0, 0);
            return;
        }
        if (model.equals("MicroGem4X5")) {
            this.setTabletParameters(500, 2650, 700, 2100, 2, 2, 19200, 410, 0, 1);
            return;
        }
        if (model.equals("MicroGemLCD")) {
            this.setTabletParameters(900, 2200, 800, 1400, 2, 2, 19200, 410, 0, 1);
            return;
        }
        if (model.equals("TracGem")) {
            this.setTabletParameters(900, 2200, 700, 1300, 2, 2, 19200, 275, 0, 1);
            return;
        }
        if (model.equals("PaperGem")) {
            this.setTabletParameters(450, 2850, 400, 3300, 2, 2, 19200, 275, 0, 1);
            return;
        }
        if (model.equals("SigLite")) {
            this.setTabletParameters(0, 6143, 6143, 0, 2, 2, 19200, 400, 0, 2);
            return;
        }
        if (model.equals("SignatureGemLCD4X3Old")) {
            this.setTabletParameters(500, 2650, 400, 2100, 4, 4, 19200, 410, 0, 0);
            this.setTabletLCDParameters(0, 240, 128, 200, 1990, 240, 1300, 0, 0, 0);
            return;
        }
        if (model.equals("SignatureGemLCD4X3New")) {
            this.setTabletParameters(500, 2650, 400, 2100, 4, 4, 19200, 410, 0, 0);
            this.setTabletLCDParameters(0, 240, 128, 240, 1955, 280, 1200, 0, 0, 0);
            return;
        }
        if (model.equals("SignatureGemLCD1X5Test")) {
            this.setTabletParameters(400, 2400, 350, 1050, 4, 4, 19200, 410, 0, 0);
            this.setTabletLCDParameters(0, 240, 64, 100, 1850, 100, 650, 0, 0, 0);
            return;
        }
        if (model.equals("SignatureGemLCD1X5")) {
            this.setTabletParameters(400, 2400, 350, 1050, 4, 4, 19200, 410, 0, 0);
            this.setTabletLCDParameters(0, 240, 64, 100, 1900, 0, 700, 0, 0, 0);
            return;
        }
        if (model.equals("SigLiteLCD4X5")) {
            this.setTabletParameters(500, 2600, 500, 2100, 4, 4, 38400, 410, 0, 0);
            this.setTabletLCDParameters(0, 320, 240, 180, 2050, 120, 1520, 0, 0, 0);
            return;
        }
        if (model.equals("SignatureGemLCD4X5")) {
            this.setTabletParameters(500, 2600, 500, 2100, 4, 4, 38400, 410, 0, 0);
            this.setTabletLCDParameters(0, 320, 240, 180, 2050, 120, 1520, 0, 0, 0);
            return;
        }
        if (model.equals("LCD1X5SE")) {
            this.setTabletParameters(400, 2400, 350, 1050, 4, 2, 115200, 410, 0, 0);
            this.setTabletLCDParameters(0, 240, 64, 100, 1850, 100, 600, 1, 6, 4);
            return;
        }
        if (model.equals("LCD4X3SE")) {
            this.setTabletParameters(500, 2650, 400, 2100, 4, 2, 115200, 410, 0, 0);
            this.setTabletLCDParameters(0, 240, 128, 200, 1930, 300, 1225, 1, 6, 4);
            return;
        }
        if (model.equals("LCD4X5SE")) {
            this.setTabletParameters(500, 2600, 500, 2100, 4, 2, 115200, 410, 0, 0);
            this.setTabletLCDParameters(0, 320, 240, 180, 2050, 120, 1520, 1, 10, 8);
            return;
        }
        if (model.equals("ClipGemHSB")) {
            this.setTabletParameters(495, 2677, 269, 3209, 2, 2, 38400, 275, 0, 0);
            return;
        }
        if (model.equals("SigGemColor57")) {
            this.setTabletParameters(300, 2370, 350, 1950, 4, 0, 115200, 410, 0, 0);
            this.setTabletLCDParameters(0, 640, 480, 100, 1970, 100, 1500, 1, 127, 127);
            return;
        }
    }

    public boolean getTabletClippingMode() {
        return this.tabletClippingMode;
    }

    public void setTabletClippingMode(boolean newValue) {
        this.tabletClippingMode = newValue;
    }

    public int getTabletLCDCaptureMode() {
        return this.tabletLCDCaptureMode;
    }

    public void setTabletLCDCaptureMode(int newMode) {
        this.tabletLCDCaptureMode = newMode;
    }

    public int getTabletLCDType() {
        return this.tabletLCDType;
    }

    public void setTabletLCDType(int newValue) {
        this.tabletLCDType = newValue;
    }

    public int getTabletLCDXSize() {
        return this.tabletLCDXSize;
    }

    public void setTabletLCDXSize(int newValue) {
        this.tabletLCDXSize = newValue;
    }

    public int getTabletLCDYSize() {
        return this.tabletLCDYSize;
    }

    public void setTabletLCDYSize(int newValue) {
        this.tabletLCDYSize = newValue;
    }

    public int getTabletLCDXStart() {
        return this.tabletLCDXStart;
    }

    public void setTabletLCDXStart(int newValue) {
        this.tabletLCDXStart = newValue;
    }

    public int getTabletLCDXStop() {
        return this.tabletLCDXStop;
    }

    public void setTabletLCDXStop(int newValue) {
        this.tabletLCDXStop = newValue;
    }

    public int getTabletLCDYStart() {
        return this.tabletLCDYStart;
    }

    public void setTabletLCDYStart(int newValue) {
        this.tabletLCDYStart = newValue;
    }

    public int getTabletLCDYStop() {
        return this.tabletLCDYStop;
    }

    public void setTabletLCDYStop(int newValue) {
        this.tabletLCDYStop = newValue;
    }

    void setTabletParameters(int xStart, int xStop, int yStart, int yStop, int filterPoints, int timingAdvance, int baudRate, int resolution, int rotationMode, int format) {
        this.tabletXStart = xStart;
        this.tabletXStop = xStop;
        this.tabletYStart = yStart;
        this.tabletYStop = yStop;
        this.tabletFilterPoints = filterPoints;
        this.tabletTimingAdvance = timingAdvance;
        this.tabletBaudRate = baudRate;
        this.tabletResolution = resolution;
        this.tabletRotationMode = 0;
        this.tabletFormat = format;
        this.calcLogicalSizes();
    }

    void calcLogicalSizes() {
        this.tabletLogicalXSize = this.tabletXStop - this.tabletXStart;
        this.tabletLogicalYSize = this.tabletYStop - this.tabletYStart;
    }

    public int getTabletMaxPointDelta() {
        return this.tabletMaxPointDelta;
    }

    public void setTabletMaxPointDelta(int newDelta) {
        this.tabletMaxPointDelta = newDelta;
    }

    public int getTabletLCDCompressMode() {
        return this.tabletLCDCompressMode;
    }

    public void setTabletLCDCompressMode(int compMode) {
        this.tabletLCDCompressMode = compMode;
    }

    public void setTabletLCDParameters(int lCDType, int xSize, int ySize, int xStart, int xStop, int yStart, int yStop, int compMode, int compFast, int compSlow) {
        this.tabletLCDCaptureMode = 0;
        this.tabletLCDType = lCDType;
        this.tabletLCDXSize = xSize;
        this.tabletLCDYSize = ySize;
        this.tabletLCDXStart = xStart;
        this.tabletLCDXStop = xStop;
        this.tabletLCDYStart = yStart;
        this.tabletLCDYStop = yStop;
        this.tabletLCDCompressMode = compMode;
        this.tabletLCDFastCompressionFactor = compFast;
        this.tabletLCDSlowCompressionFactor = compSlow;
    }

    public void setTabletLogicalXSize(int newLogicalXSize) {
        this.tabletLogicalXSize = newLogicalXSize;
    }

    public void setTabletLogicalYSize(int newLogicalYSize) {
        this.tabletLogicalYSize = newLogicalYSize;
    }
}

